<?php
/* --------------------------------------------------------------
  PublishedThemePathCacheReader.php 2019-12-12
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/

use \League\Flysystem\FileNotFoundException;

/**
 * Class PublishedThemePathCacheReader
 */
class PublishedThemePathCacheReader implements PublishedThemePathCacheReaderInterface
{
    /**
     * @var FilesystemAdapter
     */
    protected $filesystem;
    
    /**
     * @var ShopPathsInterface
     */
    protected $shopPaths;
    
    
    /**
     * PublishedThemePathCacheReader constructor.
     *
     * @param FilesystemAdapter  $filesystem
     * @param ShopPathsInterface $shopPaths
     */
    public function __construct(FilesystemAdapter $filesystem, ShopPathsInterface $shopPaths)
    {
        $this->filesystem = $filesystem;
        $this->shopPaths  = $shopPaths;
    }
    
    
    /**
     * @inheritDoc
     */
    public function getCacheFileData(): string
    {
        try {
            return $this->filesystem->read($this->shopPaths->cacheFilePath());
        } catch (FileNotFoundException $fileNotFoundException) {
            unset($fileNotFoundException);
            throw new CacheFileNotFoundException;
        }
    }
}